"""
Spherical Harmonic Audio Codec (SHAC) Package

A modular implementation of a spatial audio codec optimized for real-time 
interactive navigation and manipulation of 3D sound fields.

This version has been integrated directly into Atabey Symphony for seamless
spatial audio functionality without external dependencies.
"""

from .core import SHACCodec, apply_early_reflections, apply_diffuse_reverberation
from .math_utils import (real_spherical_harmonic, associated_legendre, factorial, 
                      double_factorial, AmbisonicNormalization)
from .utils import (AmbisonicOrdering, HRTFInterpolationMethod, DirectivityPattern,
                 SourceAttributes, RoomAttributes, BinauralRendererConfig)
from .encoders import convert_to_spherical, convert_to_cartesian, encode_mono_source, encode_stereo_source
from .processors import rotate_ambisonics, decode_to_speakers
from .binauralizer import binauralize_ambisonics, load_hrtf_database, apply_frequency_dependent_effects
from .io import SHACFileWriter, SHACFileReader

__version__ = '1.0.0'